<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Utils;


defined('ABSPATH') || die();

class ReacTheme_Elementor_Testimonial_Widget extends \Elementor\Widget_Base
{
    /**
     * Get widget name.
     *
     * Retrieve rsgallery widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'rt-testimonial';
    }

    /**
     * Get widget title.
     *
     * Retrieve rsgallery widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('RT Testimonial', 'rtelements');
    }

    /**
     * Get widget icon.
     *
     * Retrieve rsgallery widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'glyph-icon flaticon-slider-3';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the rsgallery widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['pielements_category'];
    }

    public function get_style_depends()
    {

        wp_register_style('rtelements-style-portfolio-slider', plugins_url('portfolio-slider-css/portfolio-slider.css', __FILE__));

        return [
            'rtelements-style-portfolio-slider'
        ];
    }

    /**
     * Register rsgallery widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        $this->start_controls_section(
            'testimonial_content',
            [
                'label' => esc_html__('General Settings', 'plugin-name')
            ]
        );

        $this->add_control(
            'testimonial_style',
            [
                'label'     => esc_html__('Style', 'rtelements'),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'style_one',
                'options'   => [
                    'style_one'      => esc_html__('Style One', 'rtelements'),
                    'style_two'      => esc_html__('Style Two', 'rtelements'),
                ],
            ]
        );

        // Repeater
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'list_content',
            [
                'label' => esc_html__('Content', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('List Content', 'plugin-name'),
                'show_label' => false,
            ]
        );



        $repeater->add_control(
            'list_icon',
            [
                'label' => esc_html__('Choose Icon', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'list_name',
            [
                'label' => esc_html__('Name', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Name', 'plugin-name'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'list_designation',
            [
                'label' => esc_html__('Designation', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Designation', 'plugin-name'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'testi_image',
            [
                'label' => esc_html__('Author Image', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $repeater->add_control(
            'rating',
            [
                'label' => esc_html__('Rating', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => 1,
                'default' => 5,
            ]
        );



        $this->add_control(
            'list_repeater',
            [
                'label' => esc_html__('Testimonial List', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_name' => esc_html__('Testimonial', 'plugin-name'),
                    ],
                ],
                'title_field' => '{{{ list_name }}}',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'content_slider',
            [
                'label' => esc_html__('Slider Settings', 'rtelements'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'slider_dots',
            [
                'label'   => esc_html__('Navigation Dots', 'rtelements'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'false',
                'options' => [
                    'true' => esc_html__('Enable', 'rtelements'),
                    'false' => esc_html__('Disable', 'rtelements'),
                ],
                'separator' => 'before',

            ]

        );
        $this->add_control(
            'slider_dots_color',
            [
                'label' => esc_html__('Navigation Dots Color', 'rsaddon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet' => 'background-color: {{VALUE}} !important;',
                ],
                'condition' => ['slider_dots' => 'true',],
            ]
        );
        $this->add_control(
            'slider_dots_color_active',
            [
                'label' => esc_html__('Active Navigation Dots Color', 'rsaddon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'background-color: {{VALUE}} !important;',
                ],
                'condition' => ['slider_dots' => 'true',],
            ]
        );

        $this->add_responsive_control(
            'slider_nav',
            [
                'label'   => esc_html__('Navigation Nav', 'rtelements'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'false',
                'options' => [
                    'true' => esc_html__('Enable', 'rtelements'),
                    'false' => esc_html__('Disable', 'rtelements'),
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'pcat_nav_text_bg_icon',
            [
                'label' => esc_html__('Nav Icon Color', 'rsaddon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev:before, {{WRAPPER}} .swiper-button-next:before' => 'color: {{VALUE}} !important;',
                ],
                'condition' => ['slider_nav' => 'true',],
            ]
        );

        $this->add_control(
            'pcat_nav_text_bg_hover_icon',
            [
                'label' => esc_html__('Nav Icon Hover Color', 'rsaddon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev:hover::before, {{WRAPPER}} .swiper-button-next:hover::before' => 'color: {{VALUE}} !important;',
                ],
                'condition' => ['slider_nav' => 'true',],
            ]
        );

        $this->add_control(
            'slider_autoplay',
            [
                'label'   => esc_html__('Autoplay', 'rtelements'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'false',
                'options' => [
                    'true' => esc_html__('Enable', 'rtelements'),
                    'false' => esc_html__('Disable', 'rtelements'),
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slider_autoplay_speed',
            [
                'label'   => esc_html__('Autoplay Slide Speed', 'rtelements'),
                'type'    => Controls_Manager::SELECT,
                'default' => 3000,
                'options' => [
                    '1000' => esc_html__('1 Seconds', 'rtelements'),
                    '2000' => esc_html__('2 Seconds', 'rtelements'),
                    '3000' => esc_html__('3 Seconds', 'rtelements'),
                    '4000' => esc_html__('4 Seconds', 'rtelements'),
                    '5000' => esc_html__('5 Seconds', 'rtelements'),
                ],
                'separator' => 'before',
                'condition' => [
                    'slider_autoplay' => 'true',
                ],
            ]
        );

        $this->add_control(
            'slider_interval',
            [
                'label'   => esc_html__('Autoplay Interval', 'rtelements'),
                'type'    => Controls_Manager::SELECT,
                'default' => 3000,
                'options' => [
                    '5000' => esc_html__('5 Seconds', 'rtelements'),
                    '4000' => esc_html__('4 Seconds', 'rtelements'),
                    '3000' => esc_html__('3 Seconds', 'rtelements'),
                    '2000' => esc_html__('2 Seconds', 'rtelements'),
                    '1000' => esc_html__('1 Seconds', 'rtelements'),
                ],
                'separator' => 'before',
                'condition' => [
                    'slider_autoplay' => 'true',
                ],
            ]
        );


        $this->add_control(
            'slider_loop',
            [
                'label'   => esc_html__('Loop', 'rtelements'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'false',
                'options' => [
                    'true' => esc_html__('Enable', 'rtelements'),
                    'false' => esc_html__('Disable', 'rtelements'),
                ],
                'separator' => 'before',

            ]

        );

        $this->end_controls_section();


        // ===========================Style=====================================//

        $this->start_controls_section(
             'testimonial_style_description',
             [
                'label' => esc_html__('Description', 'plugin-name'),
                'tab'   => Controls_Manager::TAB_STYLE,
             ]
        );
        
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'plugin-name'),
                'name'     => 'testimonial_style_description_typ',
                'selector' => '{{WRAPPER}} .testimonials-review-main-wrapper .single-review-area-soalri p.dsic, {{WRAPPER}} .testimonials-review-main-wrapper .single-review-area-soalri p',
        
            ]
        );
        
        $this->add_control(
            'testimonial_style_description_color',
            [
                'label'     => esc_html__('Color', 'plugin-name'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-review-main-wrapper .single-review-area-soalri p.dsic, {{WRAPPER}} .testimonials-review-main-wrapper .single-review-area-soalri  p' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial_style_description_margin',
            [
                'label' => esc_html__( 'Margin', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-review-main-wrapper .single-review-area-soalri p.dsic' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'testimonial_style_description_padding',
            [
                'label'      => __('Padding', 'plugin-name'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .testimonials-review-main-wrapper .single-review-area-soalri p.dsic' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );
        
        
        $this->end_controls_section();


        $this->start_controls_section(
             'testimonial_style_name',
             [
                'label' => esc_html__('Name', 'plugin-name'),
                'tab'   => Controls_Manager::TAB_STYLE,
             ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'plugin-name'),
                'name'     => 'testimonial_style_name_typ',
                'selector' => '{{WRAPPER}} .testimonials-review-main-wrapper .single-review-area-soalri .author-area .title',
        
            ]
        );
        
        $this->add_control(
            'testimonial_style_name_color',
            [
                'label'     => esc_html__('Color', 'plugin-name'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-review-main-wrapper .single-review-area-soalri .author-area .title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial_style_name_margin',
            [
                'label' => esc_html__( 'Margin', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-review-main-wrapper .single-review-area-soalri .author-area .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'testimonial_style_name_padding',
            [
                'label'      => __('Padding', 'plugin-name'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .testimonials-review-main-wrapper .single-review-area-soalri .author-area .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );
        
        
        
        $this->end_controls_section();


        $this->start_controls_section(
             'testimonial_style_designation',
             [
                'label' => esc_html__('Designation', 'plugin-name'),
                'tab'   => Controls_Manager::TAB_STYLE,
             ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'plugin-name'),
                'name'     => 'testimonial_style_designation_typ',
                'selector' => '{{WRAPPER}} .testimonials-review-main-wrapper .single-review-area-soalri .author-area span',
        
            ]
        );
        
        $this->add_control(
            'testimonial_style_designation_color',
            [
                'label'     => esc_html__('Color', 'plugin-name'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-review-main-wrapper .single-review-area-soalri .author-area span' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial_style_designation_margin',
            [
                'label' => esc_html__( 'Margin', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-review-main-wrapper .single-review-area-soalri .author-area span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'testimonial_style_designation_padding',
            [
                'label'      => __('Padding', 'plugin-name'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .testimonials-review-main-wrapper .single-review-area-soalri .author-area span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );
        
        
        
        $this->end_controls_section();


        $this->start_controls_section(
             'testimonial_style_rat',
             [
                'label' => esc_html__('Rating', 'plugin-name'),
                'tab'   => Controls_Manager::TAB_STYLE,
             ]
        );
        
        
        $this->add_control(
            'rat_color',
            [
                'label' => esc_html__( 'Rating Color', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-review-main-wrapper .single-review-area-soalri .author-area .star-area i' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        
        $this->end_controls_section();


        $this->start_controls_section(
             'testimonial_style_nbav',
             [
                'label' => esc_html__('Navigation', 'plugin-name'),
                'tab'   => Controls_Manager::TAB_STYLE,
             ]
        );
        
        
        $this->add_control(
            'testimonial_style_nbav_color',
            [
                'label' => esc_html__( 'Active Color', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mySwiper-testimonials-solari span.swiper-pagination-bullet.swiper-pagination-bullet-active' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        
        
        $this->end_controls_section();
    }

    /**
     * Render rsgallery widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {

        $settings    = $this->get_settings_for_display();
        $autoplaySpeed   = $settings['slider_autoplay_speed'];
        $autoplaySpeed   = !empty($autoplaySpeed) ? $autoplaySpeed : '1000';
        $interval        = $settings['slider_interval'];
        $interval        = !empty($interval) ? $interval : '3000';
        $slider_autoplay = $settings['slider_autoplay'] === 'true' ? 'true' : 'false';
        $pauseOnHover    = $settings['slider_stop_on_hover'] === 'true' ? 'true' : 'false';
        $pauseOnInter    = $settings['slider_stop_on_interaction'] === 'true' ? 'true' : 'false';
        $sliderDots      = $settings['slider_dots'] == 'true' ? 'true' : 'false';
        $sliderNav       = $settings['slider_nav'] == 'true' ? 'true' : 'false';
        $infinite        = $settings['slider_loop'] === 'true' ? 'true' : 'false';
       
       
        $next_text       = !empty($next_text) ? $next_text : '';
        $unique          = rand(2012, 35120);
        $all_pcat = rselemetns_woocommerce_product_categories();
        if ($slider_autoplay == 'true') {
            $slider_autoplay = 'autoplay: { ';
            $slider_autoplay .= 'delay: ' . $interval;
            if ($pauseOnHover == 'true') {
                $slider_autoplay .= ', pauseOnMouseEnter: true';
            } else {
                $slider_autoplay .= ', pauseOnMouseEnter: false';
            }
            if ($pauseOnInter == 'true') {
                $slider_autoplay .= ', disableOnInteraction: true';
            } else {
                $slider_autoplay .= ', disableOnInteraction: false';
            }
            $slider_autoplay .= ' }';
        } else {
            $slider_autoplay = 'autoplay: false';
        }
        ?>


        <div class="testimonials-review-main-wrapper">

            <div class="swiper rt-testimonial-<?php echo esc_attr($settings['testimonial_style']); ?> rt_slider-<?php echo esc_attr($unique); ?>">
                <div class="swiper-wrapper">

                    <?php if ($settings['testimonial_style'] == 'style_one') { ?>
                        <?php foreach ($settings['list_repeater'] as $item) : ?>
                            <div class="swiper-slide">
                                <!-- single review area start -->
                                <div class="single-review-area-soalri">
                                    <?php if (!empty($item['list_icon']['url'])) :   ?>
                                        <img src="<?php echo esc_url($item['list_icon']['url']) ?>" alt="<?php echo esc_attr('image') ?>" class="quote">
                                    <?php endif ?>
                                    <p class="dsic">
                                        <?php if (!empty($item['list_content'])) :   ?>
                                            <?php echo wp_kses_post($item['list_content']) ?>
                                        <?php endif ?>
                                    </p>
                                    <div class="author-area">
                                        <?php if (!empty($item['testi_image']['url'])) :   ?>
                                            <img src="<?php echo esc_url($item['testi_image']['url']) ?>" alt="<?php echo esc_attr('image') ?>" class="authoe">
                                        <?php endif ?>

                                        <?php if (!empty($item['list_name'])) :   ?>
                                            <h6 class="title"><?php echo esc_html($item['list_name']) ?></h6>
                                        <?php endif ?>
                                        <?php if (!empty($item['list_designation'])) :   ?>
                                            <span><?php echo esc_html($item['list_designation']) ?></span>
                                        <?php endif ?>
                                        <div class="star-area">
                                            <?php
                                                $rating = intval($item['rating']);
                                                for ($i = 1; $i <= 5; $i++) {
                                                    $star_class = ($i <= $rating) ? 'fas fa-star' : '';
                                                    echo '<i class="' . $star_class . '"></i>';
                                                }
                                            ?>
                                        </div>

                                    </div>
                                </div>
                                <!-- single review area end -->
                            </div>
                        <?php endforeach; ?>
                    <?php } else { ?>
                    <?php foreach ($settings['list_repeater'] as $item) : ?>
                        <div class="swiper-slide">
                            <!-- single review area start -->
                            <div class="single-review-area-soalri single-review-two">
                                <?php if (!empty($item['testi_image']['url'])) :   ?>
                                    <img src="<?php echo esc_url($item['testi_image']['url']) ?>" alt="<?php echo esc_attr('image') ?>" class="authoe">
                                <?php endif ?>
                                <p class="dsic">
                                    <?php if (!empty($item['list_content'])) :   ?>
                                        <?php echo wp_kses_post($item['list_content']) ?>
                                    <?php endif ?>
                                </p>
                                <div class="author-area">
                                    <?php if (!empty($item['list_icon']['url'])) :   ?>
                                        <div class="rt-author-img">
                                            <img src="<?php echo esc_url($item['list_icon']['url']) ?>" alt="<?php echo esc_attr('image') ?>" class="quote">
                                        </div>
                                    <?php endif ?>
                                    <div class="rt-author-des">
                                        <?php if (!empty($item['list_name'])) :   ?>
                                            <h6 class="title"><?php echo esc_html($item['list_name']) ?></h6>
                                        <?php endif ?>
                                        <?php if (!empty($item['list_designation'])) :   ?>
                                            <span><?php echo esc_html($item['list_designation']) ?></span>
                                        <?php endif ?> 
                                    </div>                                  
                                </div>
                            </div>
                            <!-- single review area end -->
                        </div>
                    <?php endforeach; } ?>
                </div>

                <?php if ($sliderDots == 'true') : ?>
                <div class="swiper-pagination"></div>
                <?php endif; ?>

                <?php if ($sliderNav == 'true') : ?>
                    <div class="rt-slider-nav">
                        <div class="swiper-button-prev">
                        </div>
                        <div class="swiper-button-next">
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>


    <script type="text/javascript">
        jQuery(document).ready(function() {
            var swiper<?php echo esc_attr($unique); ?><?php echo esc_attr($unique); ?> = new Swiper(".rt_slider-<?php echo esc_attr($unique); ?>", {
                slidesPerView: 1,
                <?php echo $seffect; ?>
                speed: <?php echo esc_attr($autoplaySpeed); ?>,
                slidesPerGroup: 1,
                loop: <?php echo esc_attr($infinite); ?>,
                <?php echo esc_attr($slider_autoplay); ?>,
                <?php if ($sliderDots == 'true') : ?>
                pagination: {
                    el: ".swiper-pagination",
                    clickable: true,
                },
            <?php endif; ?>
                centeredSlides: false,

                <?php if ($sliderNav == 'true') : ?>
                navigation: {
                    nextEl: ".swiper-button-next",
                    prevEl: ".swiper-button-prev",
                }
                <?php endif; ?>
            });
        });
    </script>



<?php
    }
} ?>