<?php
/*** Child Theme Function  ***/

// Chargement des styles
function solari_enqueue_child_theme_styles() {
    wp_enqueue_style('solari-style', get_template_directory_uri() . '/style.css');
    wp_enqueue_style('child-style', get_stylesheet_directory_uri() . '/style.css', array('solari-style'));
}
add_action('wp_enqueue_scripts', 'solari_enqueue_child_theme_styles'); 

// Chargement d'un fichier JS global (si nécessaire)
function solari_enqueue_child_theme_scripts() {
    wp_enqueue_script(
        'child-custom-js',
        get_stylesheet_directory_uri() . '/custom.js',
        array(),
        filemtime(get_stylesheet_directory() . '/custom.js'), // version pour éviter le cache
        true
    );
}
add_action('wp_enqueue_scripts', 'solari_enqueue_child_theme_scripts');


// Permet de récupérer l'URL de la page dans un champ hidden CF7 avec default:get

function enqueue_page_url_script() {
    wp_enqueue_script(
        'cf7-page-url',
        get_stylesheet_directory_uri() . '/js/page-url.js',
        array(),
        null,
        true
    );
}
add_action('wp_enqueue_scripts', 'enqueue_page_url_script');



function desactiver_clic_slider_page_accueil() {
    if (is_front_page()) {
        wp_enqueue_script(
            'disable-slider-click',
            get_stylesheet_directory_uri() . '/js/disable-slider-image-click.js',
            array(),
            null,
            true // Placer en footer
        );
    }
}
add_action('wp_enqueue_scripts', 'desactiver_clic_slider_page_accueil');




