<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;

defined('ABSPATH') || die();

class Reactheme_Elementor_Sservices_Grid_Widget extends \Elementor\Widget_Base
{


	/**
	 * Get widget name.
	 *
	 * Retrieve counter widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'rt-service-grid';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve counter widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('RT Services', 'rtelements');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'glyph-icon flaticon-support';
	}

	/**
	 * Retrieve the list of scripts the counter widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.3.0
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_categories()
	{
		return ['pielements_category'];
	}


	/**
	 * Register services widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls()
	{


		$this->start_controls_section(
			'service_general_content',
			[
				'label' => esc_html__('General', 'plugin-name')
			]
		);


		$this->add_control(
			'general_section_style',
			[
				'label'     => esc_html__('Style', 'rtelements'),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'style_one',
				'options'   => [
					'style_one'      => esc_html__('Style One', 'rtelements'),
					'style_two'      => esc_html__('Style Two', 'rtelements'),
					'style_three'      => esc_html__('Style Three', 'rtelements'),
					'style_four'      => esc_html__('Style Four', 'rtelements'),
					'style_five'      => esc_html__('Style Five', 'rtelements'),
					'style_six'      => esc_html__('Style Six', 'rtelements'),
					'style_seven'      => esc_html__('Style Seven', 'rtelements'),
					'style_eight'      => esc_html__('Style Eight', 'rtelements'),
					'style_nine'      => esc_html__('Style Nine', 'rtelements'),
				],
			]
		);


		$this->add_control(
			'service__icon_cicle',
			[
				'label' => esc_html__( 'Icon Circle', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'your-plugin' ),
				'label_off' => esc_html__( 'Hide', 'your-plugin' ),
				'default' => 'no',
				'condition' => [
				    'general_section_style' => 'style_nine'
				],
			]
		);


		$this->end_controls_section();


		$this->start_controls_section(
			'service_content',
			[
				'label' => esc_html__('Content', 'plugin-name')
			]
		);


		$this->add_control(
			'service_content_icon',
			[
				'label' => esc_html__('Icon', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);

		$this->add_control(
			'service_content_title_sub',
			[
				'label' => esc_html__('Sub Title', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__('', 'plugin-name'),
				'placeholder' => esc_html__('', 'plugin-name'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'service_content_title',
			[
				'label' => esc_html__('Title', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__('Default title', 'plugin-name'),
				'placeholder' => esc_html__('Type your title here', 'plugin-name'),
				'label_block' => true,
			]
		);


		$this->add_control(
			'service_content_description',
			[
				'label' => esc_html__('Description', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'rows' => 10,
				'default' => esc_html__('Default description', 'plugin-name'),
				'placeholder' => esc_html__('Type your description here', 'plugin-name'),
			]
		);

		$this->add_control(
			'service_content_image',
			[
				'label' => esc_html__('Choose Image', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'service_content_btn_text',
			[
				'label' => esc_html__('Button Text', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__('Read More', 'plugin-name'),
				'placeholder' => esc_html__('Type your button text here', 'plugin-name'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'service_content_btn_link',
			[
				'label' => esc_html__('Link', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__('https://your-link.com', 'plugin-name'),
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
					'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'service_content_btn_icon',
			[
				'label' => esc_html__('Button Icon', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fa fa-arrow-right',
					'library' => 'solid',
				],
			]
		);

		$this->add_control(
			'service_content_number',
			[
				'label' => esc_html__('Number', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Type your number here', 'plugin-name'),
				'label_block' => true,
			]
		);

		$this->end_controls_section();


		// ===============================Style============================================//
		$this->start_controls_section(
			'services_style_icon',
			[
				'label' => esc_html__('Icon', 'plugin-name'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
			'services_style_icon_icon_color',
			[
				'label' => esc_html__('SVG Color', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-service-solari .icon-area svg path' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .icon svg path' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .icon-area svg path' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .single-service-solari .icon-area i' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .icon i' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .icon-area i' => 'fill: {{VALUE}}',

				],
			]
		);

		$this->add_responsive_control(
			'services_style_icon_svg_size',
			[
				'label' => esc_html__('SVG Size', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',

				],
				'selectors' => [
					'{{WRAPPER}} .single-service-solari .icon-area svg' => 'width: {{VALUE}}',
					'{{WRAPPER}} .icon svg' => 'width: {{VALUE}} !important',
					'{{WRAPPER}} .image-area .icon svg' => 'width: {{VALUE}} !important',
					'{{WRAPPER}} .icon-area svg ' => 'width: {{VALUE}}',
					'{{WRAPPER}} .single-service-solari .icon-area i' => 'font-size: {{VALUE}}',
					'{{WRAPPER}} .icon i' => 'font-size: {{VALUE}}',
					'{{WRAPPER}} .icon-area i' => 'font-size: {{VALUE}}',

				],
			]
		);


		$this->add_control(
			'icon_border_color',
			[
				'label' => esc_html__('Border Color', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rts-single-service-solar-energy .icon' => 'border:1px solid {{VALUE}}',
					'{{WRAPPER}} .single-solari-service-start .icon-area' => 'border:1px solid {{VALUE}}',
					'{{WRAPPER}} .single-service-start .image-area .icon' => 'border:1px solid {{VALUE}}',
					'{{WRAPPER}} .rts-single-working-process .icon' => 'border:1px solid {{VALUE}}',
					'{{WRAPPER}} .single-service-area-6 .inner-content .icon' => 'border:1px solid {{VALUE}}',
				],
			]
		);


		$this->add_control(
			'icon_border_bac_color',
			[
				'label' => esc_html__('Background Color', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-solari-service-start .icon-area' => 'background: {{VALUE}}',
					'{{WRAPPER}} .rts-single-service-solar-energy .icon' => 'background: {{VALUE}}',
					'{{WRAPPER}} .single-service-start .image-area .icon' => 'background: {{VALUE}}',
					'{{WRAPPER}} .rts-single-working-process .icon' => 'background: {{VALUE}}',
					'{{WRAPPER}} .single-service-area-6 .inner-content .icon' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
            'icon_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .single-solari-service-start .icon-area' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );


		$this->end_controls_section();


		$this->start_controls_section(
			'services_style_title',
			[
				'label' => esc_html__('Title', 'plugin-name'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'plugin-name'),
				'name'     => 'services_style_title_typ',
				'selector' => '{{WRAPPER}} .title',


			]
		);

		$this->add_control(
			'services_style_title_color',
			[
				'label'     => esc_html__('Color', 'plugin-name'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'services_style_title_colorhc',
			[
				'label'     => esc_html__('Hover Color (Card)', 'plugin-name'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-solari-service-start:hover .title' => 'color: {{VALUE}};',
					'{{WRAPPER}} .single-service-solari:hover .title' => 'color: {{VALUE}};',
					'{{WRAPPER}} .single-service-style-four-h4:hover .title' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rts-single-service-solar-energy:hover .title' => 'color: {{VALUE}};',
					'{{WRAPPER}} .single-feature-soalri-3:hover .title' => 'color: {{VALUE}};',
					'{{WRAPPER}} .single-service-start:hover .title' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rts-single-working-process:hover .title' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'services_style_title_colorh',
			[
				'label'     => esc_html__('Hover Color', 'plugin-name'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title:hover' => 'color: {{VALUE}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'services_style_title_margin',
			[
				'label' => esc_html__('Margin', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'services_style_title_padding',
			[
				'label'      => __('Padding', 'plugin-name'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);





		$this->end_controls_section();

		$this->start_controls_section(
			'services_style_desc',
			[
				'label' => esc_html__('Description', 'plugin-name'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'plugin-name'),
				'name'     => 'services_style_desc_typ',
				'selector' => '{{WRAPPER}} .disc',

			]
		);

		$this->add_control(
			'services_style_desc_color',
			[
				'label'     => esc_html__('Color', 'plugin-name'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .disc' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'services_style_desc_colorhc',
			[
				'label'     => esc_html__('Hover Color (Card)', 'plugin-name'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-solari-service-start:hover .disc' => 'color: {{VALUE}};',
					'{{WRAPPER}} .single-service-solari:hover .disc' => 'color: {{VALUE}};',
					'{{WRAPPER}} .single-service-style-four-h4:hover .disc' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rts-single-service-solar-energy:hover .disc' => 'color: {{VALUE}};',
					'{{WRAPPER}} .single-feature-soalri-3:hover .disc' => 'color: {{VALUE}};',
					'{{WRAPPER}} .single-service-start:hover .disc' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rts-single-working-process:hover .disc' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'services_style_desc_colorh',
			[
				'label'     => esc_html__('Hover Color', 'plugin-name'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .disc:hover' => 'color: {{VALUE}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'services_style_desc_margin',
			[
				'label' => esc_html__('Margin', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .disc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'services_style_desc_padding',
			[
				'label'      => __('Padding', 'plugin-name'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .disc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);



		$this->end_controls_section();


		$this->start_controls_section(
			'services_style_btn_normal',
			[
				'label' => esc_html__('Button', 'plugin-name'),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'general_section_style' => ['style_one', 'style_two', 'style_four', 'style_five','style_nine'],
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'plugin-name'),
				'name'     => 'services_style_btn_normal_typ',
				'selector' => '{{WRAPPER}} .btn-read-more-c-primary',

			]
		);

		$this->add_control(
			'services_style_btn_normal_color',
			[
				'label'     => esc_html__('Color', 'plugin-name'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-read-more-c-primary' => 'color: {{VALUE}};',
					'{{WRAPPER}} .btn-read-more-c-primary i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .read-more-btn' => 'color: {{VALUE}};',
					'{{WRAPPER}} .read-more-btn i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .read-more' => 'color: {{VALUE}};',
					'{{WRAPPER}} .read-more i' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'services_style_btn_normal_colorgcc',
			[
				'label'     => esc_html__('Hover Color', 'plugin-name'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-read-more-c-primary:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .read-more-btn:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .read-more:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .single-feature-soalri-3 a.read-more-btn:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'services_style_btn_normal_colorhc',
			[
				'label'     => esc_html__('Hover Color (Card)', 'plugin-name'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-solari-service-start:hover a.read-more-btn' => 'color: {{VALUE}};',
					'{{WRAPPER}} .single-feature-soalri-3:hover a.read-more-btn' => 'color: {{VALUE}};',
					'{{WRAPPER}} .single-service-style-four-h4:hover a.btn-read-more-c-primary' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'services_style_btn_normal_margin',
			[
				'label' => esc_html__('Margin', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .btn-read-more-c-primary' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .read-more-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .read-more' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'services_style_btn_normal_padding',
			[
				'label'      => __('Padding', 'plugin-name'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .btn-read-more-c-primary' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .read-more-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .read-more' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);



		$this->end_controls_section();


		$this->start_controls_section(
			'service_btnn',
			[
				'label' => esc_html__('Button', 'plugin-name'),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'general_section_style' => ['style_three', 'style_six',],
				],
			]
		);


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'service_btnn_typography',
				'selector' => '{{WRAPPER}} a.rts-btn.btn-primary',
			]
		);

		$this->add_control(
			'service_btnn_color',
			[
				'label' => esc_html__('Color', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.rts-btn.btn-primary' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .single-service-start .inner-content a.rts-btn' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'service_btnn_colordfd',
			[
				'label' => esc_html__('Background', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rts-btn.btn-primary::before' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .rts-btn.btn-primary::before' => 'background: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'service_btnn_colofdr',
			[
				'label' => esc_html__('Hover Background', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rts-btn.btn-primary:hover' => 'background: {{VALUE}}',
					'{{WRAPPER}} .rts-btn.btn-primary:hover' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'service_btnn_margin',
			[
				'label' => esc_html__('Margin', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} a.rts-btn.btn-primary' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .single-service-start .inner-content a.rts-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'service_btnn_padding',
			[
				'label'      => __('Padding', 'plugin-name'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} a.rts-btn.btn-primary' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .single-service-start .inner-content a.rts-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'services_style_num',
			[
				'label' => esc_html__('Number', 'plugin-name'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'number_color',
			[
				'label' => esc_html__('Color', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-service-style-four-h4::after' => '-webkit-text-stroke-color: {{VALUE}}',
					'{{WRAPPER}} .rts-single-working-process .content .step_number span' => '-webkit-text-stroke-color: {{VALUE}}',
					'{{WRAPPER}} .num-icon' => '-webkit-text-stroke-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'number_colorh',
			[
				'label' => esc_html__('Hover Color', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .num-icon:hover' => '-webkit-text-stroke-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'nm_bac_color',
			[
				'label' => esc_html__('Background', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rts-single-working-process .content .step_number' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'number_width',
			[
				'label'       => esc_html__('Stroke Width', 'plugin-name'),
				'type'        => Controls_Manager::TEXT,
				'description' => 'Unit in px',
				'selectors'   => [
					'{{WRAPPER}} .single-service-style-four-h4::after ' => '-webkit-text-stroke-width: {{VALUE}}px;',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'services_style_card',
			[
				'label' => esc_html__('Card', 'plugin-name'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
			'servcie_card_color',
			[
				'label' => esc_html__('Background Color', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-service-solari::after' => 'background: {{VALUE}}',
					'{{WRAPPER}} .single-service-style-four-h4' => 'background: {{VALUE}}',
					'{{WRAPPER}} .rts-single-service-solar-energy' => 'background: {{VALUE}}',
					'{{WRAPPER}} .single-feature-soalri-3' => 'background: {{VALUE}}',
					'{{WRAPPER}} .single-service-start' => 'background: {{VALUE}}',
					'{{WRAPPER}} .service-single-s-main' => 'background: {{VALUE}}',
					'{{WRAPPER}} .single-solari-service-start::after' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'servcie_card_padding',
			[
				'label'      => __('Padding', 'plugin-name'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .single-service-solari' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .single-service-style-four-h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .rts-single-service-solar-energy' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .single-feature-soalri-3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .single-service-start' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .service-single-s-main' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'servcie_card_border_radius',
			[
				'label'      => __('Border Radius', 'plugin-name'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .single-service-solari' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .single-service-style-four-h4' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .rts-single-service-solar-energy' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .single-feature-soalri-3' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .single-service-start' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .service-single-s-main' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);


		$this->add_control(
			'card_border_color',
			[
				'label' => esc_html__('Border Color', 'plugin-name'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-service-style-four-h4' => 'border-right:1px solid {{VALUE}}',
					'{{WRAPPER}} .service-single-s-main' => 'border-right:1px solid {{VALUE}}',
				],
			]
		);


		$this->end_controls_section();
	}

	/**
	 * Render counter widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	/**
	 * Render counter widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		?>

		


		<?php if ($settings['general_section_style'] == 'style_one') : ?>

			<div class="single-service-solari">
			<?php if(!empty($settings['service_content_image']['url']) ) :?>
				<div class="image-bg">
					<img src="<?php echo esc_url($settings['service_content_image']['url'])?>"  alt=""/>
				</div>
			<?php endif; ?>
				<div class="icon-area">
					<?php if (!empty($settings['service_content_icon'])) :   ?>
						<?php \Elementor\Icons_Manager::render_icon($settings['service_content_icon'], ['aria-hidden' => 'true']); ?>
					<?php endif ?>
				</div>
				<a href="<?php echo esc_url($settings['service_content_btn_link']['url']) ?>">
					<?php if (!empty($settings['service_content_title'])) :   ?>
						<h5 class="title"><?php echo esc_html($settings['service_content_title']) ?></h5>
					<?php endif ?>
				</a>
				<p class="disc">
					<?php if (!empty($settings['service_content_description'])) :   ?>
						<?php echo esc_html($settings['service_content_description']) ?>
					<?php endif ?>
				</p>
			</div>

		<?php endif; ?>


		<?php if ($settings['general_section_style'] == 'style_two') : ?>

			<div class="single-service-style-four-h4" data-after-content="<?php echo esc_attr($settings['service_content_number']); ?>">
			<span class="num-icon"><?php echo esc_html($settings['service_content_number'])?></span>
				<div class="icon">
					<?php if (!empty($settings['service_content_icon'])) :   ?>
						<?php \Elementor\Icons_Manager::render_icon($settings['service_content_icon'], ['aria-hidden' => 'true']); ?>
					<?php endif ?>
				</div>
				<div class="contenmt-inner">
					<a href="<?php echo esc_url($settings['service_content_btn_link']['url']) ?>">
						<h4 class="title">
							<?php if (!empty($settings['service_content_title'])) :   ?>
								<?php echo wp_kses($settings['service_content_title'], wp_kses_allowed_html('post'))  ?>
							<?php endif ?>
						</h4>
					</a>
					<?php if(!empty($settings['service_content_btn_text'])): ?>
					<a href="<?php echo esc_url($settings['service_content_btn_link']['url']) ?>" class="btn-read-more-c-primary"><?php echo esc_html($settings['service_content_btn_text']) ?>
						<?php if (!empty($settings['service_content_btn_icon'])) :   ?>
							<?php \Elementor\Icons_Manager::render_icon($settings['service_content_btn_icon'], ['aria-hidden' => 'true']); ?>
						<?php endif ?>
					</a> <?php endif; ?>
				</div>
			</div>



		<?php endif; ?>


		<?php if ($settings['general_section_style'] == 'style_three') : ?>

			<div class="rts-single-service-solar-energy">
				<div class="icon">
					<?php if (!empty($settings['service_content_icon'])) :   ?>
						<?php \Elementor\Icons_Manager::render_icon($settings['service_content_icon'], ['aria-hidden' => 'true']); ?>
					<?php endif ?>
				</div>
				<h6 class="title">
					<?php if (!empty($settings['service_content_title'])) :   ?>
						<?php echo wp_kses($settings['service_content_title'], wp_kses_allowed_html('post'))  ?>
					<?php endif ?>
				</h6>
				<p class="disc">
					<?php if (!empty($settings['service_content_description'])) :   ?>
						<?php echo esc_html($settings['service_content_description']) ?>
					<?php endif ?>
				</p>
				<?php if (!empty($settings['service_content_btn_text'])) :   ?>
					<a href="<?php echo esc_url($settings['service_content_btn_link']['url']) ?>" class="rts-btn btn-primary"><?php echo esc_html($settings['service_content_btn_text']) ?></a>
				<?php endif ?>

			</div>

		<?php endif; ?>


		<?php if ($settings['general_section_style'] == 'style_four') : ?>

			<div class="single-feature-soalri-3">
				<div class="icon">
					<?php if (!empty($settings['service_content_icon'])) :   ?>
						<?php \Elementor\Icons_Manager::render_icon($settings['service_content_icon'], ['aria-hidden' => 'true']); ?>
					<?php endif ?>
				</div>
				<h5 class="title">
					<?php if (!empty($settings['service_content_title'])) :   ?>
						<?php echo wp_kses($settings['service_content_title'], wp_kses_allowed_html('post'))  ?>
					<?php endif ?>
				</h5>
				<p class="disc">
					<?php if (!empty($settings['service_content_description'])) :   ?>
						<?php echo esc_html($settings['service_content_description']) ?>
					<?php endif ?>
				</p>
				<?php if (!empty($settings['service_content_btn_text'])) :   ?>
					<a href="<?php echo esc_url($settings['service_content_btn_link']['url']) ?>" class="read-more-btn"><?php echo esc_html($settings['service_content_btn_text']) ?>
					
						<?php \Elementor\Icons_Manager::render_icon($settings['service_content_btn_icon'], ['aria-hidden' => 'true']); ?>
					
				</a>
				<?php endif ?>
			</div>

		<?php endif; ?>


		<?php if ($settings['general_section_style'] == 'style_five') : ?>

			<div class="single-solari-service-start">
			<?php if(!empty($settings['service_content_image']['url']) ) :?>
				<div class="image-bg">
					<img src="<?php echo esc_url($settings['service_content_image']['url'])?>"  alt=""/>
				</div>
			<?php endif; ?>
				<div class="icon-area">
					<?php if (!empty($settings['service_content_icon'])) :   ?>
						<?php \Elementor\Icons_Manager::render_icon($settings['service_content_icon'], ['aria-hidden' => 'true']); ?>
					<?php endif ?>
				</div>

				<?php if (!empty($settings['service_content_title_sub'])) :   ?>
					<span class="rt-serv-sub"> <?php echo esc_html($settings['service_content_title_sub']) ?></span>
				<?php endif ?>

				<a href="<?php echo esc_url($settings['service_content_btn_link']['url']) ?>">
					<?php if (!empty($settings['service_content_title'])) :   ?>
						<h5 class="title"><?php echo esc_html($settings['service_content_title']) ?></h5>
					<?php endif ?>
				</a>
				<p class="disc">
					<?php if (!empty($settings['service_content_description'])) :   ?>
						<?php echo esc_html($settings['service_content_description']) ?>
					<?php endif ?>
				</p>
				<?php if (!empty($settings['service_content_btn_text'])) :   ?>
				<a href="<?php echo esc_url($settings['service_content_btn_link']['url']) ?>" class="read-more-btn"><?php echo esc_html($settings['service_content_btn_text']) ?><?php if (!empty($settings['service_content_btn_icon'])) :   ?>
					<?php \Elementor\Icons_Manager::render_icon($settings['service_content_btn_icon'], ['aria-hidden' => 'true']); ?>
				<?php endif ?></a> <?php endif;?>
			</div>

		<?php endif; ?>

		<?php if ($settings['general_section_style'] == 'style_six') : ?>

			<div class="single-service-start">
				<div class="image-area">
					<?php if (!empty($settings['service_content_image']['url'])) :   ?>
						<a href="<?php echo esc_url($settings['service_content_btn_link']['url']) ?>" class="thumbnail">
							<img src="<?php echo esc_url($settings['service_content_image']['url']) ?>" alt="<?php echo esc_attr('image') ?>">
						</a>
					<?php endif ?>
					<div class="icon">
						<?php if (!empty($settings['service_content_icon'])) :   ?>
							<?php \Elementor\Icons_Manager::render_icon($settings['service_content_icon'], ['aria-hidden' => 'true']); ?>
						<?php endif ?>
					</div>
				</div>
				<div class="inner-content">
					<a href="<?php echo esc_url($settings['service_content_btn_link']['url']) ?>">
						<?php if (!empty($settings['service_content_title'])) :   ?>
							<h5 class="title"><?php echo esc_html($settings['service_content_title']) ?></h5>
						<?php endif ?>
					</a>
					<p class="disc">
						<?php if (!empty($settings['service_content_description'])) :   ?>
							<?php echo esc_html($settings['service_content_description']) ?>
						<?php endif ?>
					</p>
					<?php if (!empty($settings['service_content_btn_text'])) :   ?>
					<a href="<?php echo esc_url($settings['service_content_btn_link']['url']) ?>" class="rts-btn btn-primary"><?php echo esc_html($settings['service_content_btn_text']) ?>
						<?php \Elementor\Icons_Manager::render_icon($settings['service_content_btn_icon'], ['aria-hidden' => 'true']); ?>
					</a>
					<?php endif; ?>
				</div>
			</div>

		<?php endif; ?>


		<?php if ($settings['general_section_style'] == 'style_seven') : ?>

			<div class="rts-single-working-process">
				<div class="icon">
					<?php if (!empty($settings['service_content_icon'])) :   ?>
						<?php \Elementor\Icons_Manager::render_icon($settings['service_content_icon'], ['aria-hidden' => 'true']); ?>
					<?php endif ?>
				</div>
				<div class="content">
					<?php if (!empty($settings['service_content_title'])) :   ?>
						<h5 class="title"><?php echo esc_html($settings['service_content_title']) ?></h5>
					<?php endif ?>
					<p class="disc">
						<?php if (!empty($settings['service_content_description'])) :   ?>
							<?php echo esc_html($settings['service_content_description']) ?>
						<?php endif ?>
					</p>
					<div class="step_number">
						<?php if (!empty($settings['service_content_number'])) :   ?>
							<span><?php echo esc_html($settings['service_content_number']) ?></span>
						<?php endif ?>
					</div>
				</div>
			</div>

		<?php endif; ?>


		<?php if ($settings['general_section_style'] == 'style_eight') : ?>

			<div class="service-single-s-main">
				<div class="icon">
					<?php if (!empty($settings['service_content_icon'])) :   ?>
						<?php \Elementor\Icons_Manager::render_icon($settings['service_content_icon'], ['aria-hidden' => 'true']); ?>
					<?php endif ?>
				</div>
				<a href="<?php echo esc_url($settings['service_content_btn_link']['url']) ?>">
					<?php if (!empty($settings['service_content_title'])) :   ?>
						<h5 class="title">
							<?php echo esc_html($settings['service_content_title']) ?>
						</h5>
					<?php endif; ?>
				</a>
				<p class="disc">
					<?php if (!empty($settings['service_content_description'])) :   ?>
						<?php echo esc_html($settings['service_content_description']) ?>
					<?php endif ?>
				</p>
				<?php if (!empty($settings['service_content_btn_text'])) :   ?>
					<a href="<?php echo esc_url($settings['service_content_btn_link']['url']) ?>" class="rts-read-more-btn"><?php echo esc_html($settings['service_content_btn_text']) ?>
						<?php \Elementor\Icons_Manager::render_icon($settings['service_content_btn_icon'], ['aria-hidden' => 'true']); ?>
					</a>
				<?php endif ?>
			</div>

		<?php endif; ?>

		<?php if ($settings['general_section_style'] == 'style_nine') : ?>
			<div class="single-service-area-6 rt-icon_cir_<?php echo esc_attr($settings['service__icon_cicle']); ?>">
				<a href="<?php echo esc_url($settings['service_content_btn_link']['url']) ?>" class="thumbnail">
					<img class="main" src="<?php echo esc_url($settings['service_content_image']['url']) ?>" alt="<?php echo esc_attr('service') ?>">
				</a>
				<div class="inner-content">
					<div class="icon">
						<?php if (!empty($settings['service_content_icon'])) :   ?>
							<?php \Elementor\Icons_Manager::render_icon($settings['service_content_icon'], ['aria-hidden' => 'true']); ?>
						<?php endif ?>
					</div>
					<div class="content">
						<?php if (!empty($settings['service_content_description'])) :   ?>
							<span class="disc"><?php echo esc_html($settings['service_content_description']) ?></span>
						<?php endif ?>

						<?php if (!empty($settings['service_content_title'])) :   ?>
							<a href="<?php echo esc_url($settings['service_content_btn_link']['url']) ?>">
								<h4 class="title">
									<?php echo wp_kses_post($settings['service_content_title']) ?>
								</h4>
							</a>
						<?php endif; ?>

						<?php if (!empty($settings['service_content_btn_text'])) :   ?>
							<a href="<?php echo esc_url($settings['service_content_btn_link']['url']) ?>" class="read-more">
								<?php echo esc_html($settings['service_content_btn_text']) ?>
								<?php \Elementor\Icons_Manager::render_icon($settings['service_content_btn_icon'], ['aria-hidden' => 'true']); ?>
							</a>
						<?php endif ?>
					</div>
				</div>
			</div>

		<?php endif; ?>

<?php

	}
}

?>